# first portion of autosyncwizard that all variations on the wizard share

	global tile_x;
	global tile_y;
	variable workflow;
	variable file_select_type;
	variable file_select_pattern;
	variable file_include_subfolders;
	variable mapunits_list;
	filename database;

	frame advancedapmstrategyframe {
		title "Advanced Point Matching Strategy";
		modal;
		textnumber searchsize;
		textnumber correlationsize;
		textnumber leastsquaresize;
		textnumber ptdensity;
		textnumber coefficientlimit;
		textnumber exteaccuracy;
		checkbox avoidshadow;
		radiobutton scantype;
		textnumber backgroundvalue;

		textnumber searchsize {
			title left center "Search Size:";
			info "Search window size";
			lock top,left,width,height;
			geometry 15,5,180,26;
			titleoffset 120 noalign;
			min 3;
			max 199;
			delta 2;
			format "3.0";
		}

		textnumber correlationsize {
			title left center "Correlation Size:";
			info "Cross correlation window size";
			lock top,left,width,height;
			geometry 15,40,180,26;
			titleoffset 120 noalign;
			min 3;
			max 99;
			delta 2;
			format "3.0";
		}

		textnumber leastsquaresize {
			title left center "Least Squares Size:";
			info "Window size for least square matching";
			lock top,left,width,height;
			geometry 15,75,180,26;
			titleoffset 120 noalign;
			min 5;
			max 99;
			delta 2;
			format "3.0";
		}

		textnumber ptdensity {
			title left center "Feature Point Density:";
			info "Feature point density based on internal default";
			lock top,left,width,height;
			geometry 240,5,215,26;
			titleoffset 155 noalign;
			delta 5;
			min 10;
			max 900;
			format "0\"%\"";
		}

		textnumber coefficientlimit {
			title left center "Minimum Point Match Quality:";
			info "Minimum quality of point match (0.5 to 1.0)";
			lock top,left,width,height;
			geometry 240,40,215,26;
			titleoffset 155 noalign;
			delta 0.01;
			min 0.60;
			max 0.99;
			format "0.00";
		}

		textnumber exteaccuracy {
			title left center "Initial Accuracy:";
			info "Relative accuracy of initial values";
			lock top,left,width,height;
			geometry 240,75,215,26;
			titleoffset 155 noalign;
			min 1;
			max 50;
			format "0\"%\"";
		}

		checkbox avoidshadow {
			title right center "Avoid Shadow";
			geometry 15, 110, 125, 26;
			lock top, left, width, height;
			info "Try to avoid shadow points";
			titleoffset 115 noalign;
			on valuechanged {
				if ($avoidshadow == 1) { 
					enable scantype;
				}
				else 
				{
					disable scantype;
				}
			}
		}

		radiobutton scantype {
			title left center "Image Scan Type:";
			geometry 240, 110, 235, 26;
			lock top, left, width, height;
			info "Shadow looks dark if image scanned positively, otherwise looks white";
			titleoffset 100 noalign;
			layout horizontal;
			titlelist { 
				"Positive",
				"Negative"
			};
			options {
				"Positive",
				"Negative"
			};
		}
			
		checkbox usemmt {
			title right center "Use Manual Tie Points for Initial Connection between Images";
			geometry 15, 145, 320, 26;
			lock top, left, width, height;
			info "Use manual tie points to establish the initial connection between images even if their map info is available";
			titleoffset 296 noalign;
		}
		
		checkbox excludebackgroundarea {
			title right center "Exclude Background Area";
			geometry 15, 180, 200, 26;
			lock top, left, width, height;
			info "Exclude image background area";
			titleoffset 135 noalign;
			on valuechanged {
				if ($excludebackgroundarea)
					enable backgroundvalue;
				else
					disable backgroundvalue;
			}
		}
		
		textnumber backgroundvalue {
			title left center "Background Value:";
			info "Specify the background value";
			lock top,left,width,height;
			geometry 240,180,215,26;
			titleoffset 155 noalign;
			max 999999.0;
			format "9.2";
		}
		
		button ok {
			title "OK";
			geometry 122, 215, 76, 26;
			lock bottom, right, width, height;
			info "Use these settings";
			on mousedown {
				SetAPMSearchSize($searchsize);
				SetAPMCorrelationSize($correlationsize);
				SetAPMLeastSquareSize($leastsquaresize);
				SetAPMPointDensity($ptdensity);
				SetAPMCoefficientLimit($coefficientlimit);
				SetAPMExteAccuracy($exteaccuracy);
				SetAPMAvoidShadow($avoidshadow);
				SetAPMScanType($scantype);
				SetAPMUseMMT($usemmt);
				SetAPMExcludeBackgroundArea($excludebackgroundarea);
				SetAPMBackgroundValue($backgroundvalue);
				undisplay advancedapmstrategyframe;
			}
		}

		button cancel {
			title "Cancel";
			geometry 198, 215, 76, 26;
			lock bottom, right, width, height;
			info "Cancel modifications to these settings";
			on mousedown {
				undisplay advancedapmstrategyframe;
			}
		}

		button help {
			title "Help";
			geometry 274, 215, 76, 26;
			lock bottom, right, width, height;
			info "Help for Advanced Point Matching Strategy";
			on mousedown {
				variable helptag;
				set helptag = "advancedapmstrategyframe" + "_" + $workflow;
				showhelp "autosyncwizard" $helptag "";
			}
		}

		on framedisplay {
			set searchsize = GetAPMSearchSize();
			set correlationsize = GetAPMCorrelationSize();
			set leastsquaresize = GetAPMLeastSquareSize();
			set ptdensity = GetAPMPointDensity();
			set coefficientlimit = GetAPMCoefficientLimit();
			set exteaccuracy = GetAPMExteAccuracy();
			set avoidshadow = GetAPMAvoidShadow();
			set scantype = GetAPMScanType();
			set usemmt = GetAPMUseMMT();
			set excludebackgroundarea = GetAPMExcludeBackgroundArea();
			set backgroundvalue = GetAPMBackgroundValue();
			if ($excludebackgroundarea)
				enable backgroundvalue;
			else
				disable backgroundvalue;
		}
	}

	frame database_select_options_frame {
		title "Options";

		variable currenttemplate;
		edittext select_pattern;
		checkbox include_subfolders;

		group optionsgroup {
			title "Multiple File Selection";

			label select_info {
				title "";
				value
"You can use this panel to select multiple files to be added 
to the selection of files to process. Clicking on the checkbox
below will enable the \"Selection Pattern\" which is used to
enter a wild card pattern that describes the files to be 
selected. The pattern may contain \"*\" and \"?\" to match any
characters. When the pattern is set press OK to continue. The
OK button will not be enabled until a file has been selected
on the File tab.";
				geometry 10, 10, 375, 110; 
			}

			checkbox select_type {
				title "Use the following Selection Pattern";
				geometry 10, 130, 375, 26;
				on valuechanged {
					set file_select_type = $select_type;
					set file_include_subfolders = $include_subfolders;
					if ($select_type) {
						enable select_pattern;
						enable include_subfolders;
					}
					else {
						disable select_pattern;
						disable include_subfolders;
					}
				}
			}

			edittext select_pattern {
				title above left "Selection Pattern:";
				/*
				** NOTE!!!  This part cannot be taller than 43 pixels high, or it
				** will do ugly things on UNIX.
				*/
				geometry 10, 158, 360, 43;
				on valuechanged { 
					set file_select_pattern = $select_pattern; 
				}
			}

			checkbox include_subfolders {
				title "Include subfolders";
				geometry 10, 210, 200, 26;
				on valuechanged { 
					set file_include_subfolders = $include_subfolders; 
				}
			}
		}

		on setselectpattern (path) {
			set currenttemplate = $database.currenttemplateget();
			if (isempty ($currenttemplate) OR $currenttemplate == "") {
				set currenttemplate = "*.*";
			}
			set select_pattern = $path + $currenttemplate; 
		}

		on filenamechoosen (fname) {
			enable select_type;
			setselectpattern (fpath ($fname));
		}

		on framedisplay {
			setselectpattern (getpref("eml" "default_data_path") + "/");
			disable select_type;
			set select_type = 0;
			set include_subfolders = 0;
			disable select_pattern;
		}
	}

	frame setoutputnamesframe {
		title "Output File Names";
		modal;

		filename outputdir;
		edittext outputfilenamesuffix;
		popuplist outputfiletype;
		button outputfiletype_def_bn;

		checkbox useoutputdirandsuffix {
			title right center "Use output directory and file name suffix for calibrated output";
			geometry 12, 5, 400, 26;
			info "Use output directory and file name suffix for calibrated output";
			value 1;
			on valuechanged {
				if (($useoutputdirandsuffix == 0) && (GetGeocorrectionType() != "Resample")) {
					disable outputdir;
					disable outputfilenamesuffix;
					hide outputfiletype;
					hide outputfiletype_def_bn;
				}
				else {
					enable outputdir;
					enable outputfilenamesuffix;
					show outputfiletype;
					show outputfiletype_def_bn;
				}
			}
			on input {
				SetDefaultUseOutputDirAndSuffix($useoutputdirandsuffix);
			}
		}

		filename outputdir {
			title left center "Default Output Directory:";
			geometry 13, 40, 427, 26;
			lock top, left, width, height;
			info "Select default directory for output files";
			titleoffset 172 noalign;
			shortform;
			fullpath;
			nocheck;
			value getpref("eml" "default_output_path")+"/";
		}

		edittext outputfilenamesuffix {
			title left center "Default Output File Name Suffix:";
			geometry 15, 75, 420, 26;
			lock top, right, width, height;
			info "Select default suffix for output file names";
			titleoffset 170 noalign;
			value getpref("autosync" "default_outputfilenamesuffix");
		}

		popuplist outputfiletype {
			title left center "Default Output File Type:";
			geometry 15, 110, 390, 26;
			lock top, left, width, height;
			info "Select default type for output files";
			titleoffset 170 noalign;
			titlelist {
				"IMAGINE Image",
				"TIFF"
			};
			names {
				"img",
				"tiff"
			};
		}
		button outputfiletype_def_bn {
			icon "favorite.ico";
			info "Save the current selection as the Preference for the default output file type";
			geometry 410, 110, 25, 25;
			lock right, top, width, height;
			on mousedown {
				setpref("autosync", "default_outputfiletype", $outputfiletype);
			}
		}
		
		button ok {
			title "OK";
			geometry 113, 145, 76, 26;
			lock bottom, right, width, height;
			info "Use these settings";
			on mousedown {
				SetDefaultUseOutputDirAndSuffix($useoutputdirandsuffix);
				SetDefaultOutputDir($outputdir);
				SetDefaultOutputFilenameSuffix($outputfilenamesuffix);
				SetDefaultOutputFileType($outputfiletype);
				SetDefaultOutputFilenames();
				undisplay setoutputnamesframe;
			}
		}

		button cancel {
			title "Cancel";
			geometry 189, 145, 76, 26;
			lock bottom, right, width, height;
			info "Cancel setting output image names";
			on mousedown {
				undisplay setoutputnamesframe;
			}
		}

		button help {
			title "Help";
			geometry 265, 145, 76, 26;
			lock bottom, right, width, height;
			info "Help for Set Output Image Names";
			on mousedown {
				variable helptag;
				set helptag = "setoutputnamesframe" + "_" + $workflow;
				showhelp "autosyncwizard" $helptag "";
			}
		}

		on framedisplay {
			set useoutputdirandsuffix = GetDefaultUseOutputDirAndSuffix();
			set outputdir = GetDefaultOutputDir();
			set outputfilenamesuffix = GetDefaultOutputFilenameSuffix();
			set outputfiletype = GetDefaultOutputFileType();
			if (GetGeocorrectionType() != "Calibrate") {
				disable useoutputdirandsuffix;
				show outputfiletype;
				show outputfiletype_def_bn;
			}
			else {
				hide outputfiletype;
				hide outputfiletype_def_bn;
			}
		}
	}

	frame resamplesettingsframe {
		title "Resample Settings";
		modal;

		group cellsize;
		textnumber cellsizex;
		textnumber cellsizey;
		group polyoption;
		
		variable cellsizexoutold;
		variable cellsizeyoutold;
		variable cellsizexout;
		variable cellsizeyout;
		checkbox forcesquarepixel;
		button setinterpmodepref;

		checkbox snapto;
		radiobutton snaptype;
		group snaptogroup;
		filename snapfile;
		textnumber snappointx;
		textnumber snappointy;

		popuplist resamplemethod {
			title left center "Resample Method:";
			geometry 15, 5, 250, 26;
			lock top, left, width, height;
			info "Select method for resampling output images";
			titleoffset 120 noalign;
			titlelist {
				"Nearest Neighbor",
				"Bilinear Interpolation",
				"Cubic Convolution",
				"Bicubic Spline"
			};
			names {
				"Nearest Neighbor",
				"Bilinear Interpolation",
				"Cubic Convolution",
				"Bicubic Spline"
			};
		}

		radiobutton cellsizesource {
			title left center "Cell Size:";
			geometry 15, 40, 300, 26;
			info "Specify output image cell size";
			titleoffset 60 noalign;
			options{"SameAsInput" "SpecifiedBelow"};
			titlelist{"Same as Input Image" "Specified Below"};
			layout horizontal;
			on input {
				if ($cellsizesource == "SpecifiedBelow") {
					set cellsizex = $cellsizexout;
					set cellsizey = $cellsizeyout;
					enable cellsize;
					enable forcesquarepixel;
					enable setinterpmodepref;
					if ($forcesquarepixel)
					{
						if ($cellsizex < $cellsizey)
						{
							set cellsizey = $cellsizex;
							set cellsizeyout = $cellsizey;
						}
						else
						{
							set cellsizex = $cellsizey;
							set cellsizexout = $cellsizex;
						}
					}
				}
				else {
					set cellsizex = GetInputImageCellSizeX();
					set cellsizey = GetInputImageCellSizeY();
					disable cellsize;
					disable forcesquarepixel;
					disable setinterpmodepref;
				}
			}
		}

		group cellsize {
			info "Cell size for output images";
			geometry 22, 66, 347, 40;
			textnumber cellsizex {
				title left center "X Cell Size:";
				geometry 7, 5, 150, 26;
				lock top, left, width, height;
				info "Set the X cell size for the output images";
				titleoffset 70 noalign;
				min 0.0;
				max 1000.0;
				format "8.2";
				value 0.0;
				on input {
					set cellsizexout = $cellsizex;
					set cellsizexoutold = $cellsizex;
					if ($forcesquarepixel)
					{
						set cellsizey = $cellsizex;
						set cellsizeyout = $cellsizey;
					}
				}
			}

			textnumber cellsizey {
				title left center "Y Cell Size:";
				geometry 183, 5, 150, 26;
				lock top, left, width, height;
				info "Set the Y cell size for the output images";
				titleoffset 70 noalign;
				min 0.0;
				max 1000.0;
				format "8.2";
				value 0.0;
				on input {
					set cellsizeyout = $cellsizey;
					set cellsizeyoutold = $cellsizey;
					if ($forcesquarepixel)
					{
						set cellsizex = $cellsizey;
						set cellsizexout = $cellsizex;
					}					
				}
			}
		}

		checkbox ignorezeros {
			title "Ignore Zero in Statistics";
			geometry 12, 120, 300, 26;
			info "Ignore zero data values when computing statistics for output images";
		}

		checkbox boundaryaction {
			title right center "Clip to Reference Image Boundary";
			geometry 12, 155, 300, 26;
			info "Select boundary action for output images";
		}
		
		checkbox forcesquarepixel {
			title "Force Square Pixels on Reprojection";
			geometry 12, 190, 200, 26;
			titleoffset 0;
			info "check to use square output cell size";
			on valuechanged
			{
				if ($forcesquarepixel)
			    {
					if ($cellsizex < $cellsizey)
					{
						set cellsizey = $cellsizex;
						set cellsizeyout = $cellsizey;
					}
					elsif ($cellsizex > $cellsizey)
					{
						set cellsizex = $cellsizey;
						set cellsizexout = $cellsizex;
					}
				}
				else
				{
					if ($cellsizex == $cellsizey)
					{
						set cellsizex = $cellsizexoutold;
						set cellsizey = $cellsizeyoutold;
						set cellsizexout = $cellsizexoutold;
						set cellsizeyout = $cellsizeyoutold;
					}
				}
					
			}
		}
		button setinterpmodepref {
			geometry 213, 190, 26, 26;
			icon "favorite.ico";
			on mousedown {
				setpref ("rasterprocess", "reproj_defaul_pixelsize_option", $forcesquarepixel);
			}				
		}
		
		checkbox snapto {
			title "Snap pixel edges to";
			geometry 12, 225, 120, 26;
			info "Make the top and left edges of the output raster line up to a point or the pixel edges in the specified raster file";
			on input {
				if ($snapto) {
					enable snaptype;
					enable snaptogroup;
				}
				else {
					disable snaptype;
					disable snaptogroup;
				}
			}
		}
		radiobutton snaptype {
			info "What the pixel edges in the output image will be aligned to";
			geometry 140, 225, 200, 50;
			options { "raster" "point"};
			titlelist { "raster image" "a point"};
			layout horizontal;
			on valuechanged {
				if ($snaptype == "raster") {
					enable snapfile;
					disable snappointx;
					disable snappointy;
				}
				else {
					enable snappointx;
					enable snappointy;
					disable snapfile;
				}
			}
		}

		group snaptogroup {
			geometry 22,252,347,63;

			filename snapfile {
				shortform;
				title above left "File to snap to:";
				geometry 10,5,185,26;
				select getpref("eml" "default_output_path")+"/*.img";
				filetypedef "raster" pseudotypes off creatable on;
				info "Output will be aligned to the pixels in this file.";
			}
			
			textnumber snappointx {
				title left center "X:";
				geometry 195,0,140,28;
				format "12.10";
				min -100000000000;
				max 100000000000;
				info "The X location to snap to";
			}
				 
			textnumber snappointy {
				title left center "Y:";
				geometry 195,30,140,28;
				format "12.10";
				min -100000000000;
				max 100000000000;
				info "The Y location to snap to";
			}
		}

		button ok {
			title "OK";
			geometry 78, 325, 76, 26;
			lock bottom, right, width, height;
			info "Use these settings";
			on mousedown {
				SetResampleMethod($resamplemethod);
				if ($cellsizesource == "SpecifiedBelow") {
					SetUseInputImageCellSize(0);
				}
				else {
					SetUseInputImageCellSize(1);
				}
				SetOutputCellSizeX($cellsizexout);
				SetOutputCellSizeY($cellsizeyout);
				
				SetIgnoreZerosInStats($ignorezeros);
				SetBoundaryAction($boundaryaction);
				SetSnapTo($snapto, $snaptype, $snapfile, $snappointx, $snappointy);
				undisplay resamplesettingsframe;
			}
		}

		button cancel {
			title "Cancel";
			geometry 154, 325, 76, 26;
			lock bottom, right, width, height;
			info "Cancel setting resample options";
			on mousedown {
				undisplay resamplesettingsframe;
			}
		}

		button help {
			title "Help";
			geometry 230, 325, 76, 26;
			lock bottom, right, width, height;
			info "Help for resample settings";
			on mousedown {
				variable helptag;
				set helptag = "resamplesettingsframe" + "_" + $workflow;
				showhelp "autosyncwizard" $helptag "";
			}
		}

		on framedisplay {
			variable snapReturn;
/*			$resamplemethod.SetNameAndTitleList(GetResampleMethodTitles(),GetResampleMethodNames()); */
			set resamplemethod = GetResampleMethod();
			
			set cellsizexout = GetOutputCellSizeX();
			if ($cellsizexout == 0.0) set cellsizexout = GetInputImageCellSizeX();
			set cellsizexoutold = $cellsizexout;
			
			set cellsizeyout = GetOutputCellSizeY();
			if ($cellsizeyout == 0.0) set cellsizeyout = GetInputImageCellSizeY();
			set cellsizeyoutold = $cellsizeyout;
			
			if (GetUseInputImageCellSize() == 0) {
				set cellsizesource = "SpecifiedBelow";
				set cellsizex = $cellsizexout;
				set cellsizey = $cellsizeyout;
				enable cellsize;
				enable forcesquarepixel;
				enable setinterpmodepref;
			}
			else {
				set cellsizesource = "SameAsInput";
				set cellsizex = GetInputImageCellSizeX();
				set cellsizey = GetInputImageCellSizeY();
				disable cellsize;
				disable forcesquarepixel;
				disable setinterpmodepref;
			}
			
			set forcesquarepixel = getpref ("rasterprocess", "reproj_defaul_pixelsize_option");
			if ($forcesquarepixel)
		    {
				if ($cellsizex < $cellsizey)
				{
					set cellsizey = $cellsizex;
					set cellsizeyout = $cellsizey;
				}
				elsif ($cellsizex > $cellsizey)
				{
					set cellsizex = $cellsizey;
					set cellsizexout = $cellsizex;
				}
			}
			else
			{
				if ($cellsizex == $cellsizey)
				{
					set cellsizex = $cellsizexoutold;
					set cellsizey = $cellsizeyoutold;
					set cellsizexout = $cellsizexoutold;
					set cellsizeyout = $cellsizeyoutold;
				}
			}

			set ignorezeros = GetIgnoreZerosInStats();
			set boundaryaction = GetBoundaryAction();
			if ($workflow == "georeference") {
				show boundaryaction;		
			}
			else if ($workflow == "edgematch") {
				hide boundaryaction;		
			}
			
			set snapReturn = GetSnapTo();
			echo "1:";
			echo $snapReturn[1];
			echo "2:";
			echo $snapReturn[2];
			echo "3:";
			echo $snapReturn[3];
			echo "4:";
			echo $snapReturn[4];
			echo "5:";
			echo $snapReturn[5];
			set snapto = $snapReturn[2];
			if($snapto != 0) {
				set snaptype = $snapReturn[1];
				if($snaptype == "raster") {
					set snapfile = $snapReturn[3];
				} else {
					set snappointx = $snapReturn[4];
					set snappointy = $snapReturn[5];
				}
			}

			if ($snapto) {
				enable snaptype;
				enable snaptogroup;
			}
			else {
				disable snaptype;
				disable snaptogroup;
			}
			if ($snaptype == "raster") {
				enable snapfile;
				disable snappointx;
				disable snappointy;
			}
			else {
				enable snappointx;
				enable snappointy;
				disable snapfile;
			}
		}
	}

	frame advancedprojectionsettingsframe {
		title "Advanced Projection Settings";
		modal;

		group polyoption;
		
		radiobutton transformationtype {
			title left center "Transformation Type:";
			info "Option for fast, but approximate, or slow, but precise, transform";
			geometry 12, 5, 360, 25;
			titleoffset 120 noalign;
			options{"Rigorous" "Polynomial Approximation"};
			titlelist{"Rigorous" "Polynomial Approximation" };
			layout horizontal;
			on input {
				if ($transformationtype == "Polynomial Approximation") {
					enable polyoption;
				}
				else {
					disable polyoption;
				}
			}
		}
		
		group polyoption {
			info "Parameters for polynomial approximation";
			geometry 22, 30, 347, 120;
			textnumber porder {
				title left center "Maximum Polynomial Order:";
				geometry 7,5,225,25;
				titleoffset 145 noalign;
				format "5.0";
				min 1;
				max 20;
				value 5;
				info "The maximum polynomial order allowed";
			} 
			textnumber ptolerance {
				title left center "Tolerance (pixels):";
				geometry 7,40,225,25;
				titleoffset 145 noalign;
				format "8.3";
				min 0.001;
				max 10.0;
				value 0.5;
				info "The approximation tolerance in pixels";
			}
			radiobutton toloption {
				title above left "If Tolerance Exceeded:";
				info "Options when approximation tolerance exceeded";
				geometry 7, 75, 345, 50;
				titleoffset 15 noalign;
				options{"Continue Approximation" "Use Rigorous Transformation"};
				titlelist{"Continue Approximation" "Use Rigorous Transformation"};
				layout horizontal;
			}
		}
		
		button ok {
			title "OK";
			geometry 78, 190, 76, 26;
			lock bottom, right, width, height;
			info "Use these settings";
			on mousedown {
				if ($transformationtype == "Rigorous") {
					SetUseRigorousTransformation(1);
				}
				else {
					SetUseRigorousTransformation(0);
				}
				SetResamplePolynomialOrder($porder);
				SetResampleTolerance($ptolerance);
				if ($toloption == "UseRigorous") {
					SetUseRigorousIfToleranceExceeded(1);
				}
				else {
					SetUseRigorousIfToleranceExceeded(0);
				}
				
				undisplay advancedprojectionsettingsframe;
			}
		}

		button cancel {
			title "Cancel";
			geometry 154, 190, 76, 26;
			lock bottom, right, width, height;
			info "Cancel setting advanced projection options";
			on mousedown {
				undisplay advancedprojectionsettingsframe;
			}
		}

		button help {
			title "Help";
			geometry 230, 190, 76, 26;
			lock bottom, right, width, height;
			info "Help for advanced projection settings";
			on mousedown {
				variable helptag;
				set helptag = "advancedprojectionsettingsframe" + "_" + $workflow;
				showhelp "autosyncwizard" $helptag "";
			}
		}

		on framedisplay {
			if (GetUseRigorousTransformation() == 1) {
				set transformationtype = "Rigorous";
				disable polyoption;
			}
			else {
				set transformationtype = "Polynomial Approximation";
				enable polyoption;
			}
			set porder = GetResamplePolynomialOrder();
			set ptolerance = GetResampleTolerance();
			if (GetUseRigorousIfToleranceExceeded() == 1) {
				set toloption = "Use Rigorous Transformation";
			}
			else {
				set toloption = "Continue Approximation";
			}		
		}
	}

	frame autosyncwizardframe {
		title "AutoSync Wizard";
		resizable;
		minimumsize 52, 32;

		variable projectfile;
		variable imagecount;
		variable sensormodeloptions;
		variable realdtmsource;
		variable dtmfile;
		variable dtmfileunits;
		variable prevdtmsource;
		
		popuplist adjmethod;
		textnumber polyorder;
		filename reportname;
		textnumber ProjectiveMinZ;
		textnumber ProjectiveMaxZ;
		checkbox samedenpart;
		checkbox Projective2D;
		textnumber Order;

		tabsheet apmtabs {
			geometry 2, 0, 662, 402;
			lock top, bottom, left, right;
		